
set more off
use "JEAS 2021.dta", replace



*** Muslims Less Likely to Vote ********************************************
set more off
logit dvcorr female age edu income i.ethnicity i.pilgubknowledge satisfaction i.muslim
estimates store m1

esttab m* using Table-A2.csv, b(3) se(2) starlevels(* .10 ** .05 *** .01) r2(3) nogaps replace
estimates clear

******* DELETE NON-MUSLIMS
drop if religion != 1


*** Feeling toward Christians as IV ****************************************
set more off
logit dvcorr female age edu income i.ethnicity i.pilgubknowledge satisfaction feelchristians
estimates store m2

margins, at(feelchristians = (1 (1) 5)) atmeans
marginsplot, name(christian1, replace) title("") subtitle("Feeling: Christians (Basic Model)", tstyle(size(medsmall))) ///
			ytitle(Pr(Vote Ahok), tstyle(size(medsmall))) xtitle(Feeling: Christians, tstyle(size(medsmall))) graphregion(color(white)) bgcolor(white)


*** Feeling toward Tionghoa as IV ******************************************
set more off
logit dvcorr female age edu income i.ethnicity i.pilgubknowledge satisfaction feeltionghoa
estimates store m3

margins, at(feeltionghoa = (1 (1) 5)) atmeans
marginsplot, name(tionghoa1, replace) title("") subtitle("Feeling: Ethnic Chinese (Basic Model)", tstyle(size(medsmall))) ///
			ytitle(Pr(Vote Ahok), tstyle(size(medsmall))) xtitle(Feeling: Ethnic Chinese, tstyle(size(medsmall))) graphregion(color(white)) bgcolor(white)


*** Feeling toward Tionghoa and Christians as IV ***************************
set more off
logit dvcorr female age edu income i.ethnicity i.pilgubknowledge satisfaction c.feelchristians c.feeltionghoa
estimates store m4

margins, at(feelchristians = (1 (1) 5)) atmeans
marginsplot, name(christian2, replace) title("") subtitle("Feeling: Christians (Full Model)", tstyle(size(medsmall))) ///
			ytitle(Pr(Vote Ahok), tstyle(size(medsmall))) xtitle(Feeling: Christians, tstyle(size(medsmall))) graphregion(color(white)) bgcolor(white)
margins, at(feeltionghoa = (1 (1) 5)) atmeans
marginsplot, name(tionghoa2, replace) title("") subtitle("Feeling: Ethnic Chinese (Full Model)", tstyle(size(medsmall))) ///
		ytitle(Pr(Vote Ahok), tstyle(size(medsmall))) xtitle(Feeling: Ethnic Chinese, tstyle(size(medsmall))) graphregion(color(white)) bgcolor(white)

graph combine christian1 christian2 tionghoa1 tionghoa2, ycommon graphregion(color(white))
graph export "Figure-2.png", replace
graph drop christian1 christian2 tionghoa1 tionghoa2

esttab m* using Table-A6.csv, b(3) se(2) starlevels(* .10 ** .05 *** .01) r2(3) nogaps replace
estimates clear

